/**
 ******************************************************************************
 *
 * @file        REG_MG82F5Bxx.INC
 *
 * @brief       This is the header file of the SFR address.
 *
 * @par         Project
 *              MG82F5Bxx
 * @version     v1.00
 * @date        2022/02/15
 * @copyright   Copyright (c) 2019 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************
 * @par         Disclaimer
 *      The Demo software is provided "AS IF"  without any warranty, either
 *      expressed or implied, including, but not limited to, the implied warranties
 *      of merchantability and fitness for a particular purpose.  The author will
 *      not be liable for any special, incidental, consequential or indirect
 *      damages due to loss of data or any other reason.
 *      These statements agree with the world wide and local dictated laws about
 *      authorship and violence against these laws.
 ******************************************************************************
 @if HIDE
 Modify History:
 * #0.57_Blake_20211103
 * >> Engineer version
 * #0.58_Blake_20211213
 * >>PartNo rename is "MG82F5Bxx"
 * >>"sbit SM00_FE" will be defined separately "sbit SM00" and "sbit FE"
 * #1.00_Blake_20220215
 * >>Remove AUXR4.bit4 at 0xC2
 * >>Remove "CKSTA" at 0xC2
 * >>Remove "OR08_P"~"OR12_P" at Page_P 0x08~ 0x12
 * >>Remove "TSTMD0_P" at Page_P 0x20
 * >>Remove "TEST1_P"~"TEST4_P" at Page_P 0x21~0x24
 * >>Remove PCON2_P.bit6 & bit0 at Page_P 0x44
 * >>Remove PCON3_P.bit0~5 at Page_P 0x45
 * >>Remove "TSTFLG0_P" at Page_P 0x4E
 * >>Remove "TSTWD_P" at Page_P 0x4F
 * >>Remove "NRR0_P" at Page_P 0x50
 * >>Remove "IFADRU_P" at Page_P 0x64
 @endif
 ******************************************************************************
 * @internal
 * @sign
 * @endinternal
 */

#ifndef __REG_MG82F5Bxx_INC
#define __REG_MG82F5Bxx_INC

GF_7          EQU      080h
GF_6          EQU      040h
GF_5          EQU      020h
GF_4          EQU      010h
GF_3          EQU      008h
GF_2          EQU      004h
GF_1          EQU      002h
GF_0          EQU      001h

SP                    DATA     081H     //Stack Pointer
SP_Page               EQU      000h

DPL                   DATA     082H     //Data Pointer Low
DPL_Page              EQU      000h

DPH                   DATA     083H     //Data Pointer High
DPH_Page              EQU      000h

SPSTAT                DATA     084H     //SPI Status Register
SPSTAT_Page           EQU      000h
// (bits in SPSTAT)
SPIF                  EQU      080h
WCOL                  EQU      040h
THRF                  EQU      020h
SPIBSY                EQU      010h
MODF                  EQU      008h
SPR2                  EQU      001h

SPCON                 DATA     085H     //SPI Control Register
SPCON_Page            EQU      000h
// (bits in SPCON)
SSIG                  EQU      080h
SPEN                  EQU      040h
DORD                  EQU      020h
MSTR                  EQU      010h
CPOL                  EQU      008h
CPHA                  EQU      004h
SPR1                  EQU      002h
SPR0                  EQU      001h

SPDAT                 DATA     086H     //SPI Data Register
SPDAT_Page            EQU      000h

PCON0                 DATA     087H     //Power Control 0
PCON0_Page            EQU      000h
// (bits in PCON0)
SMOD1                 EQU      080h
SMOD0                 EQU      040h
POF0                  EQU      010h
GF1                   EQU      008h
GF0                   EQU      004h
PD                    EQU      002h
IDL                   EQU      001h

TCON                  DATA     088H     //Timer Control
TCON_Page             EQU      000h
// (bits in TCON)
TF1                   BIT      TCON.7
TR1                   BIT      TCON.6
TF0                   BIT      TCON.5
TR0                   BIT      TCON.4
IE1                   BIT      TCON.3
IT1                   BIT      TCON.2
IE0                   BIT      TCON.1
IT0                   BIT      TCON.0

TMOD                  DATA     089H     //Timer Mode
TMOD_Page             EQU      000h
// (bits in TMOD)
T1GATE                EQU      080h
T1C_T                 EQU      040h
T1M1                  EQU      020h
T1M0                  EQU      010h
T0GATE                EQU      008h
T0C_T                 EQU      004h
T0M1                  EQU      002h
T0M0                  EQU      001h

TL0                   DATA     08AH     //Timer Low 0
TL0_Page              EQU      000h

TL1                   DATA     08BH     //Timer Low 1
TL1_Page              EQU      000h

TH0                   DATA     08CH     //Timer High 0
TH0_Page              EQU      000h

TH1                   DATA     08DH     //Timer High 1
TH1_Page              EQU      000h

SFIE                  DATA     08EH     //System Flag INT En.
SFIE_Page             EQU      000h
// (bits in SFIE)
SIDFIE                EQU      080h
MCDRE                 EQU      040h
MCDFIE                EQU      020h
RTCFIE                EQU      010h
BOF1IE                EQU      004h
BOF0IE                EQU      002h
WDTFIE                EQU      001h

P1                    DATA     090H     //Port 1
P1_Page               EQU      000h
// (bits in P1)
P17                   BIT      P1.7
P16                   BIT      P1.6
P15                   BIT      P1.5
P14                   BIT      P1.4
P13                   BIT      P1.3
P12                   BIT      P1.2
P11                   BIT      P1.1
P10                   BIT      P1.0

P1M0                  DATA     091H     //P1 Mode Register 0
P1M0_Page             EQU      000h
// (bits in P1M0)
P1M07                 EQU      080h
P1M06                 EQU      040h
P1M05                 EQU      020h
P1M04                 EQU      010h
P1M03                 EQU      008h
P1M02                 EQU      004h
P1M01                 EQU      002h
P1M00                 EQU      001h

P1AIO                 DATA     092H     //P1 Analog Input Only
P1AIO_Page            EQU      000h
// (bits in P1AIO)
P17AIO                EQU      080h
P16AIO                EQU      040h
P15AIO                EQU      020h
P14AIO                EQU      010h
P13AIO                EQU      008h
P12AIO                EQU      004h
P11AIO                EQU      002h
P10AIO                EQU      001h

P2M0                  DATA     095H     //P2 Mode Register 0
P2M0_Page             EQU      000h
// (bits in P2M0)
P2M07                 EQU      080h
P2M06                 EQU      040h
P2M05                 EQU      020h
P2M04                 EQU      010h
P2M03                 EQU      008h
P2M02                 EQU      004h
P2M01                 EQU      002h
P2M00                 EQU      001h

BOREV                 DATA     096H     //Bit Order Reversed
BOREV_Page            EQU      000h

PCON1                 DATA     097H     //Power Control 1
PCON1_Page            EQU      000h
// (bits in PCON1)
SWRF                  EQU      080h
EXRF                  EQU      040h
MCDF                  EQU      020h
RTCF                  EQU      010h
BOF1                  EQU      004h
BOF0                  EQU      002h
WDTF                  EQU      001h

S0CON                 DATA     098H     //Serial 0 Control
S0CON_Page            EQU      000h
// (bits in S0CON)
SM00                  BIT      S0CON.7
FE                    BIT      S0CON.7
SM10                  BIT      S0CON.6
SM20                  BIT      S0CON.5
REN0                  BIT      S0CON.4
TB80                  BIT      S0CON.3
RB80                  BIT      S0CON.2
TI0                   BIT      S0CON.1
RI0                   BIT      S0CON.0

S1CON                 DATA     098H     //Serial 1 Control
S1CON_Page            EQU      001h
// (bits in S1CON)
SM01                  BIT      S1CON.7
SM11                  BIT      S1CON.6
SM21                  BIT      S1CON.5
REN1                  BIT      S1CON.4
TB81                  BIT      S1CON.3
RB81                  BIT      S1CON.2
TI1                   BIT      S1CON.1
RI1                   BIT      S1CON.0

S0BUF                 DATA     099H     //Serial 0 Buffer
S0BUF_Page            EQU      000h

S1BUF                 DATA     099H     //Serial 1 Buffer
S1BUF_Page            EQU      001h

S1BRT                 DATA     09AH     //S1 Baud-Rate Timer
S1BRT_Page            EQU      001h

S1BRC                 DATA     09BH     //S1 Baud-Rate Counter
S1BRC_Page            EQU      001h

S0CFG                 DATA     09CH     //S0 Configuration
S0CFG_Page            EQU      000h
// (bits in S0CFG)
URTS                  EQU      080h
SMOD2                 EQU      040h
URM0X3                EQU      020h
SM30                  EQU      010h
S0DOR                 EQU      008h
BTI                   EQU      004h
UTIE                  EQU      002h

S1CFG                 DATA     09CH     //S1 Configuration
S1CFG_Page            EQU      001h
// (bits in S1CFG)
SM31                  EQU      080h
S1EVPS                EQU      040h
S1DOR                 EQU      020h
S1TR                  EQU      010h
S1MOD1                EQU      008h
S1TX12                EQU      004h
S1CKOE                EQU      002h
S1TME                 EQU      001h

S1CFG1                DATA     09DH     //S1 Configuration 1
S1CFG1_Page           EQU      001h
// (bits in S1CFG1)
SBF1                  EQU      080h
TXER1                 EQU      040h
S1B16                 EQU      020h
ATBR1                 EQU      010h
TXRX1                 EQU      008h
SYNC1                 EQU      004h

LINCFG                DATA     09DH     //LIN Configuration
LINCFG_Page           EQU      001h

S1CFG2                DATA     09DH     //S1 Configuration 2
S1CFG2_Page           EQU      002h
// (bits in S1CFG2)
ESDE1                 EQU      080h
ESDF1                 EQU      040h
PEF1                  EQU      020h
ESOE1                 EQU      010h
S1BRS3                EQU      008h
S1BRS2                EQU      004h
S1BRS1                EQU      002h
S1BRS0                EQU      001h

SMCCFG                DATA     09DH     //SMC Configuration
SMCCFG_Page           EQU      002h

P2                    DATA     0A0H     //Port 2
P2_Page               EQU      000h
// (bits in P2)
P27                   BIT      P2.7
P26                   BIT      P2.6
P25                   BIT      P2.5
P24                   BIT      P2.4
P23                   BIT      P2.3
P22                   BIT      P2.2
P21                   BIT      P2.1
P20                   BIT      P2.0

AUXR0                 DATA     0A1H     //Auxiliary Register 0
AUXR0_Page            EQU      000h
// (bits in AUXR0)
P60OC1                EQU      080h
P60OC0                EQU      040h
P60FD                 EQU      020h
T0XL                  EQU      010h
P4FS1                 EQU      008h
P4FS0                 EQU      004h
INT1H                 EQU      002h
INT0H                 EQU      001h

AUXR1                 DATA     0A2H     //Auxiliary Register 1
AUXR1_Page            EQU      000h
// (bits in AUXR1)
P1KBIH                EQU      080h
P3KBIL                EQU      040h
P4SPI                 EQU      020h
P3S1                  EQU      010h
P3S1MI                EQU      008h
P6TWI0                EQU      004h
P3CEX                 EQU      002h
DPS                   EQU      001h

AUXR2                 DATA     0A3H     //Auxiliary Register 2
AUXR2_Page            EQU      000h
// (bits in AUXR2)
INT3IS1               EQU      080h
INT3IS0               EQU      040h
INT2IS1               EQU      020h
INT2IS0               EQU      010h
T1X12                 EQU      008h
T0X12                 EQU      004h
T1CKOE                EQU      002h
T0CKOE                EQU      001h

AUXR3                 DATA     0A4H     //Auxiliary Register 3
AUXR3_Page            EQU      000h
// (bits in AUXR3)
STAF                  EQU      080h
STOF                  EQU      040h
BPOC1                 EQU      020h
BPOC0                 EQU      010h
C0PLK                 EQU      008h
P1S0MI                EQU      004h
P3ECI                 EQU      002h
P3TWI1                EQU      001h

IE                    DATA     0A8H     //Interrupt Enable
IE_Page               EQU      000h
// (bits in IE)
EA                    BIT      IE.7
ET2                   BIT      IE.5
ES0                   BIT      IE.4
ET1                   BIT      IE.3
EX1                   BIT      IE.2
ET0                   BIT      IE.1
EX0                   BIT      IE.0

SADDR                 DATA     0A9H     //Slave Address
SADDR_Page            EQU      000h

SFRPI                 DATA     0ACH     //SFR Page Index
SFRPI_Page            EQU      000h
// (bits in SFRPI)
IDX3                  EQU      008h
IDX2                  EQU      004h
IDX1                  EQU      002h
IDX0                  EQU      001h

EIE1                  DATA     0ADH     //Extended INT Enable 1
EIE1_Page             EQU      000h
// (bits in EIE1)
ETWI1                 EQU      080h
ETWI0                 EQU      040h
EKB                   EQU      020h
ES1                   EQU      010h
ESF                   EQU      008h
EPCA                  EQU      004h
EADC                  EQU      002h
ESPI                  EQU      001h

EIP1L                 DATA     0AEH     //Ext. INT Priority 1 Low
EIP1L_Page            EQU      000h
// (bits in EIP1L)
PTWI1L                EQU      080h
PTWI0L                EQU      040h
PKBL                  EQU      020h
PS1L                  EQU      010h
PSFL                  EQU      008h
PPCAL                 EQU      004h
PADCL                 EQU      002h
PSPIL                 EQU      001h

EIP1H                 DATA     0AFH     //Ext. INT Priority 1 High
EIP1H_Page            EQU      000h
// (bits in EIP1H)
PTWI1H                EQU      080h
PTWI0H                EQU      040h
PKBH                  EQU      020h
PS1H                  EQU      010h
PSFH                  EQU      008h
PPCAH                 EQU      004h
PADCH                 EQU      002h
PSPIH                 EQU      001h

P3                    DATA     0B0H     //Port 3
P3_Page               EQU      000h
// (bits in P3)
P35                   BIT      P3.5
P34                   BIT      P3.4
P33                   BIT      P3.3
P32                   BIT      P3.2
P31                   BIT      P3.1
P30                   BIT      P3.0

P3M0                  DATA     0B1H     //P3 Mode Register 0
P3M0_Page             EQU      000h
// (bits in P3M0)
P3M05                 EQU      020h
P3M04                 EQU      010h
P3M03                 EQU      008h
P3M02                 EQU      004h
P3M01                 EQU      002h
P3M00                 EQU      001h

P3M1                  DATA     0B2H     //P3 Mode Register 1
P3M1_Page             EQU      000h
// (bits in P3M1)
P3M15                 EQU      020h
P3M14                 EQU      010h
P3M13                 EQU      008h
P3M12                 EQU      004h
P3M11                 EQU      002h
P3M10                 EQU      001h

P4M0                  DATA     0B3H     //P4 Mode Register 0
P4M0_Page             EQU      000h
// (bits in P4M0)
P4M07                 EQU      080h
P4M05                 EQU      020h
P4M04                 EQU      010h
P4M01                 EQU      002h
P4M00                 EQU      001h

PUCON0                DATA     0B4H     //Port Pull-Up Control 0
PUCON0_Page           EQU      000h
// (bits in PUCON0)
P4PU1                 EQU      080h
P4PU0                 EQU      040h
P2PU1                 EQU      020h
P2PU0                 EQU      010h
P1PU1                 EQU      008h
P1PU0                 EQU      004h

PUCON1                DATA     0B4H     //Port Pull-Up Control 1
PUCON1_Page           EQU      001h
// (bits in PUCON1)
P6PU0                 EQU      004h

PDRVC0                DATA     0B4H     //Port Driving Control 0
PDRVC0_Page           EQU      002h
// (bits in PDRVC0)
P3DC1                 EQU      080h
P3DC0                 EQU      040h
P2DC1                 EQU      020h
P2DC0                 EQU      010h
P1DC1                 EQU      008h
P1DC0                 EQU      004h

PDRVC1                DATA     0B4H     //Port Driving Control 1
PDRVC1_Page           EQU      003h
// (bits in PDRVC1)
P4DC1                 EQU      002h
P4DC0                 EQU      001h

PFDC0                 DATA     0B4H     //Port Fast Driving Ctl0
PFDC0_Page            EQU      004h
// (bits in PFDC0)
P3FDCH                EQU      080h
P3FDCL                EQU      040h
P2FDCH                EQU      020h
P2FDCL                EQU      010h
P1FDCH                EQU      008h
P1FDCL                EQU      004h
P4FDCH                EQU      002h
P4FDCL                EQU      001h

P6M0                  DATA     0B5H     //P6 Mode Register 0
P6M0_Page             EQU      000h
// (bits in P6M0)
P6M01                 EQU      002h
P6M00                 EQU      001h

RTCTM                 DATA     0B6H     //RTC Timer Register
RTCTM_Page            EQU      000h
// (bits in RTCTM)
RTCCS1                EQU      080h
RTCCS0                EQU      040h
RTCCT5                EQU      020h
RTCCT4                EQU      010h
RTCCT3                EQU      008h
RTCCT2                EQU      004h
RTCCT1                EQU      002h
RTCCT0                EQU      001h

IP0H                  DATA     0B7H     //Interrupt Priority 0 High
IP0H_Page             EQU      000h
// (bits in IP0H)
PX3H                  EQU      080h
PX2H                  EQU      040h
PT2H                  EQU      020h
PSH                   EQU      010h
PT1H                  EQU      008h
PX1H                  EQU      004h
PT0H                  EQU      002h
PX0H                  EQU      001h

IP0L                  DATA     0B8H     //Interrupt Priority Low
IP0L_Page             EQU      000h
// (bits in IP0L)
PX3L                  BIT      IP0L.7
PX2L                  BIT      IP0L.6
PT2L                  BIT      IP0L.5
PSL                   BIT      IP0L.4
PT1L                  BIT      IP0L.3
PX1L                  BIT      IP0L.2
PT0L                  BIT      IP0L.1
PX0L                  BIT      IP0L.0

SADEN                 DATA     0B9H     //Slave Address Mask
SADEN_Page            EQU      000h

ADCFG1                DATA     0BBH     //ADC Configuration 1
ADCFG1_Page           EQU      000h
// (bits in ADCFG1)
VRS2                  EQU      040h
VRS1                  EQU      020h
SIGN                  EQU      010h
AOS3                  EQU      008h
AOS2                  EQU      004h
AOS1                  EQU      002h
AOS0                  EQU      001h

PWMCR                 DATA     0BCH     //PWM Control Reg.
PWMCR_Page            EQU      000h
// (bits in PWMCR)
PCAE                  EQU      080h
EXDT                  EQU      040h
PFCF                  EQU      010h
PFCM                  EQU      008h
PFCS2                 EQU      004h
PFCS1                 EQU      002h
PFCS0                 EQU      001h

PDTCR                 DATA     0BDH     //PWM Dead-Time Control Register
PDTCR_Page            EQU      000h
// (bits in PDTCR)
DTPS1                 EQU      080h
DTPS0                 EQU      040h
DT5                   EQU      020h
DT4                   EQU      010h
DT3                   EQU      008h
DT2                   EQU      004h
DT1                   EQU      002h
DT0                   EQU      001h

RTCCR                 DATA     0BEH     //RTC Control Reg.
RTCCR_Page            EQU      000h
// (bits in RTCCR)
RTCE                  EQU      080h
RTCO                  EQU      040h
RTCRL5                EQU      020h
RTCRL4                EQU      010h
RTCRL3                EQU      008h
RTCRL2                EQU      004h
RTCRL1                EQU      002h
RTCRL0                EQU      001h

CKCON1                DATA     0BFH     //Clock Control 1
CKCON1_Page           EQU      000h
// (bits in CKCON1)
XTOR                  EQU      080h
XCKS5                 EQU      020h
XCKS4                 EQU      010h
XCKS3                 EQU      008h
XCKS2                 EQU      004h
XCKS1                 EQU      002h
XCKS0                 EQU      001h

XICON                 DATA     0C0H     //External INT Control
XICON_Page            EQU      000h
// (bits in XICON)
INT3H                 BIT      XICON.7
EX3                   BIT      XICON.6
IE3                   BIT      XICON.5
IT3                   BIT      XICON.4
INT2H                 BIT      XICON.3
EX2                   BIT      XICON.2
IE2                   BIT      XICON.1
IT2                   BIT      XICON.0

XICFG                 DATA     0C1H     //Ext. INT. Configured
XICFG_Page            EQU      000h
// (bits in XICFG)
INT1IS1               EQU      080h
INT1IS0               EQU      040h
INT0IS1               EQU      020h
INT0IS0               EQU      010h
X3FLT                 EQU      008h
X2FLT                 EQU      004h
X1FLT                 EQU      002h
X0FLT                 EQU      001h

AUXR4                 DATA     0C2H     //Auxiliary Register 4
AUXR4_Page            EQU      000h
// (bits in AUXR4)
I2C1CF                EQU      080h
TWICF                 EQU      040h
SPI0M0                EQU      010h
TWI1PS1               EQU      004h
T2EXS0                EQU      002h
C0PS0                 EQU      001h

AUXR5                 DATA     0C2H     //Auxiliary Register 5
AUXR5_Page            EQU      001h
// (bits in AUXR5)
S0PS0                 EQU      001h

ADCFG2                DATA     0C2H     //ADC Configuration 2
ADCFG2_Page           EQU      002h
// (bits in ADCFG2)
SHT7                  EQU      080h
SHT6                  EQU      040h
SHT5                  EQU      020h
SHT4                  EQU      010h
SHT3                  EQU      008h
SHT2                  EQU      004h
SHT1                  EQU      002h
SHT0                  EQU      001h

ADCFG3                DATA     0C2H     //ADC Configuration 3
ADCFG3_Page           EQU      003h
// (bits in ADCFG3)
ADPS1                 EQU      080h
ADPS0                 EQU      040h
ADHS                  EQU      020h
ADCKS3                EQU      010h
ARES0                 EQU      004h

P1PUC                 DATA     0C2H     //P1 Pull-Up Control
P1PUC_Page            EQU      004h
// (bits in P1PUC)
P1PUC7                EQU      080h
P1PUC6                EQU      040h
P1PUC5                EQU      020h
P1PUC4                EQU      010h
P1PUC3                EQU      008h
P1PUC2                EQU      004h
P1PUC1                EQU      002h
P1PUC0                EQU      001h

P2PUC                 DATA     0C2H     //P2 Pull-Up Control
P2PUC_Page            EQU      005h
// (bits in P2PUC)
P2PUC7                EQU      080h
P2PUC6                EQU      040h
P2PUC5                EQU      020h
P2PUC4                EQU      010h
P2PUC3                EQU      008h
P2PUC2                EQU      004h
P2PUC1                EQU      002h
P2PUC0                EQU      001h

P4PUC                 DATA     0C2H     //P4 Pull-Up Control
P4PUC_Page            EQU      006h
// (bits in P4PUC)
P4PUC7                EQU      080h
P4PUC5                EQU      020h
P4PUC4                EQU      010h
P4PUC1                EQU      002h
P4PUC0                EQU      001h

P6PUC                 DATA     0C2H     //P6 Pull-Up Control
P6PUC_Page            EQU      007h
// (bits in P6PUC)
P6PUC1                EQU      002h
P6PUC0                EQU      001h

ADCFG0                DATA     0C3H     //ADC Configuration 0
ADCFG0_Page           EQU      000h
// (bits in ADCFG0)
ADCKS2                EQU      080h
ADCKS1                EQU      040h
ADCKS0                EQU      020h
ADRJ                  EQU      010h
VRS0                  EQU      004h
ADTM1                 EQU      002h
ADTM0                 EQU      001h

ADCON0                DATA     0C4H     //ADC Control 0
ADCON0_Page           EQU      000h
// (bits in ADCON0)
ADCEN                 EQU      080h
CHS3                  EQU      020h
ADCI                  EQU      010h
ADCS                  EQU      008h
CHS2                  EQU      004h
CHS1                  EQU      002h
CHS0                  EQU      001h

ADCDL                 DATA     0C5H     //ADC Data Low
ADCDL_Page            EQU      000h
// (bits in ADCDL)
ADCV3                 EQU      080h
ADCV2                 EQU      040h
ADCV1                 EQU      020h
ADCV0                 EQU      010h

ADCDH                 DATA     0C6H     //ADC Data High
ADCDH_Page            EQU      000h
// (bits in ADCDH)
ADCV11                EQU      080h
ADCV10                EQU      040h
ADCV9                 EQU      020h
ADCV8                 EQU      010h
ADCV7                 EQU      008h
ADCV6                 EQU      004h
ADCV5                 EQU      002h
ADCV4                 EQU      001h

CKCON0                DATA     0C7H     //Clock Control 0
CKCON0_Page           EQU      000h
// (bits in CKCON0)
AFS                   EQU      080h
ENCKM                 EQU      040h
CKMIS1                EQU      020h
CKMIS0                EQU      010h
CCKS                  EQU      008h
SCKS2                 EQU      004h
SCKS1                 EQU      002h
SCKS0                 EQU      001h

T2CON                 DATA     0C8H     //Timer 2 Control Reg.
T2CON_Page            EQU      000h
// (bits in T2CON)
TF2                   BIT      T2CON.7
EXF2                  BIT      T2CON.6
RCLK                  BIT      T2CON.5
TCLK                  BIT      T2CON.4
EXEN2                 BIT      T2CON.3
TR2                   BIT      T2CON.2
C_T2                  BIT      T2CON.1
CP_RL2                BIT      T2CON.0

T2MOD                 DATA     0C9H     //Timer 2 mode Reg.
T2MOD_Page            EQU      000h
// (bits in T2MOD)
T2EXH                 EQU      020h
T2X12                 EQU      010h
CPAZ                  EQU      004h
T2OE                  EQU      002h
DCEN2                 EQU      001h

RCAP2L                DATA     0CAH     //Timer2 Capture Low
RCAP2L_Page           EQU      000h

RCAP2H                DATA     0CBH     //Timer2 Capture High
RCAP2H_Page           EQU      000h

TL2                   DATA     0CCH     //Timer Low 2
TL2_Page              EQU      000h

TH2                   DATA     0CDH     //Timer High 2
TH2_Page              EQU      000h

CLRL                  DATA     0CEH     //CL Reload register
CLRL_Page             EQU      000h

CHRL                  DATA     0CFH     //CH Reload register
CHRL_Page             EQU      000h

PSW                   DATA     0D0H     //Program Status Word
PSW_Page              EQU      000h
// (bits in PSW)
CY                    BIT      PSW.7
AC                    BIT      PSW.6
F0                    BIT      PSW.5
RS1                   BIT      PSW.4
RS0                   BIT      PSW.3
OV                    BIT      PSW.2
F1                    BIT      PSW.1
P                     BIT      PSW.0

SIADR                 DATA     0D1H     //TWI0 Address Reg.
SIADR_Page            EQU      000h
// (bits in SIADR)
GC                    EQU      001h

SI1ADR                DATA     0D1H     //TWI1 Address Reg.
SI1ADR_Page           EQU      001h
// (bits in SI1ADR)
GC1                   EQU      001h

SIDAT                 DATA     0D2H     //TWI0 Data Reg.
SIDAT_Page            EQU      000h

SI1DAT                DATA     0D2H     //TWI1 Data Reg.
SI1DAT_Page           EQU      001h

SISTA                 DATA     0D3H     //TWI0 Status Reg.
SISTA_Page            EQU      000h

SI1STA                DATA     0D3H     //TWI1 Status Reg.
SI1STA_Page           EQU      001h

SICON                 DATA     0D4H     //TWI0 Control Reg.
SICON_Page            EQU      000h
// (bits in SICON)
CR2                   EQU      080h
ENSI                  EQU      040h
STA                   EQU      020h
STO                   EQU      010h
SI                    EQU      008h
AA                    EQU      004h
CR1                   EQU      002h
CR0                   EQU      001h

SI1CON                DATA     0D4H     //TWI1 Control Reg.
SI1CON_Page           EQU      001h
// (bits in SI1CON)
CR21                  EQU      080h
ENSI1                 EQU      040h
STA1                  EQU      020h
STO1                  EQU      010h
SI1                   EQU      008h
AA1                   EQU      004h
CR11                  EQU      002h
CR01                  EQU      001h

KBPATN                DATA     0D5H     //Keypad Pattern
KBPATN_Page           EQU      000h

KBCON                 DATA     0D6H     //Keypad Control
KBCON_Page            EQU      000h
// (bits in KBCON)
KBES                  EQU      020h
PATNS                 EQU      002h
KBIF                  EQU      001h

KBMASK                DATA     0D7H     //Keypad Int. Mask
KBMASK_Page           EQU      000h

CCON                  DATA     0D8H     //PCA Control Reg.
CCON_Page             EQU      000h
// (bits in CCON)
CF                    BIT      CCON.7
CR                    BIT      CCON.6
CCF5                  BIT      CCON.5
CCF4                  BIT      CCON.4
CCF3                  BIT      CCON.3
CCF2                  BIT      CCON.2
CCF1                  BIT      CCON.1
CCF0                  BIT      CCON.0

CMOD                  DATA     0D9H     //PCA Mode Reg.
CMOD_Page             EQU      000h
// (bits in CMOD)
CIDL                  EQU      080h
BME4                  EQU      040h
BME2                  EQU      020h
BME0                  EQU      010h
CPS2                  EQU      008h
CPS1                  EQU      004h
CPS0                  EQU      002h
ECF                   EQU      001h

CCAPM0                DATA     0DAH     //PCA Module0 Mode
CCAPM0_Page           EQU      000h
// (bits in CCAPM0)
DTE0                  EQU      080h
ECOM0                 EQU      040h
CAPP0                 EQU      020h
CAPN0                 EQU      010h
MAT0                  EQU      008h
TOG0                  EQU      004h
PWM0                  EQU      002h
ECCF0                 EQU      001h

CCAPM6                DATA     0DAH     //PCA Module6 Mode
CCAPM6_Page           EQU      001h
// (bits in CCAPM6)
BME6                  EQU      080h
PWM6                  EQU      002h

CCAPM1                DATA     0DBH     //PCA Module1 Mode
CCAPM1_Page           EQU      000h
// (bits in CCAPM1)
ECOM1                 EQU      040h
CAPP1                 EQU      020h
CAPN1                 EQU      010h
MAT1                  EQU      008h
TOG1                  EQU      004h
PWM1                  EQU      002h
ECCF1                 EQU      001h

CCAPM7                DATA     0DBH     //PCA Module7 Mode
CCAPM7_Page           EQU      001h
// (bits in CCAPM7)
PWM7                  EQU      002h

CCAPM2                DATA     0DCH     //PCA Module2 Mode
CCAPM2_Page           EQU      000h
// (bits in CCAPM2)
DTE2                  EQU      080h
ECOM2                 EQU      040h
CAPP2                 EQU      020h
CAPN2                 EQU      010h
MAT2                  EQU      008h
TOG2                  EQU      004h
PWM2                  EQU      002h
ECCF2                 EQU      001h

CCAPM3                DATA     0DDH     //PCA Module3 Mode
CCAPM3_Page           EQU      000h
// (bits in CCAPM3)
ECOM3                 EQU      040h
CAPP3                 EQU      020h
CAPN3                 EQU      010h
MAT3                  EQU      008h
TOG3                  EQU      004h
PWM3                  EQU      002h
ECCF3                 EQU      001h

CCAPM4                DATA     0DEH     //PCA Module4 Mode
CCAPM4_Page           EQU      000h
// (bits in CCAPM4)
DTE4                  EQU      080h
ECOM4                 EQU      040h
CAPP4                 EQU      020h
CAPN4                 EQU      010h
MAT4                  EQU      008h
TOG4                  EQU      004h
PWM4                  EQU      002h
ECCF4                 EQU      001h

CCAPM5                DATA     0DFH     //PCA Module5 Mode
CCAPM5_Page           EQU      000h
// (bits in CCAPM5)
ECOM5                 EQU      040h
CAPP5                 EQU      020h
CAPN5                 EQU      010h
MAT5                  EQU      008h
TOG5                  EQU      004h
PWM5                  EQU      002h
ECCF5                 EQU      001h

ACC                   DATA     0E0H     //Accumulator
ACC_Page              EQU      000h

WDTCR                 DATA     0E1H     //WDT Control register
WDTCR_Page            EQU      000h
// (bits in WDTCR)
WREN                  EQU      080h
NSW                   EQU      040h
ENW                   EQU      020h
CLRW                  EQU      010h
WIDL                  EQU      008h
PS2                   EQU      004h
PS1                   EQU      002h
PS0                   EQU      001h

IFD                   DATA     0E2H     //ISP Flash data
IFD_Page              EQU      000h

IFADRH                DATA     0E3H     //ISP Flash Addr. High
IFADRH_Page           EQU      000h

IFADRL                DATA     0E4H     //ISP Flash Addr. Low
IFADRL_Page           EQU      000h

IFMT                  DATA     0E5H     //ISP Mode Table
IFMT_Page             EQU      000h
// (bits in IFMT)
MS3                   EQU      008h
MS2                   EQU      004h
MS1                   EQU      002h
MS0                   EQU      001h

SCMD                  DATA     0E6H     //ISP Serial Command
SCMD_Page             EQU      000h

ISPCR                 DATA     0E7H     //ISP Control Register
ISPCR_Page            EQU      000h
// (bits in ISPCR)
ISPEN                 EQU      080h
SWBS                  EQU      040h
SWRST                 EQU      020h
CFAIL                 EQU      010h

P4                    DATA     0E8H     //Port 4
P4_Page               EQU      000h
// (bits in P4)
P47                   BIT      P4.7
P45                   BIT      P4.5
P44                   BIT      P4.4
P41                   BIT      P4.1
P40                   BIT      P4.0

CL                    DATA     0E9H     //PCA base timer Low
CL_Page               EQU      000h

CCAP0L                DATA     0EAH     //PCA module0 capture Low
CCAP0L_Page           EQU      000h

CCAP6L                DATA     0EAH     //PCA module6 capture Low
CCAP6L_Page           EQU      001h

CCAP1L                DATA     0EBH     //PCA module1 capture Low
CCAP1L_Page           EQU      000h

CCAP7L                DATA     0EBH     //PCA module7 capture Low
CCAP7L_Page           EQU      001h

CCAP2L                DATA     0ECH     //PCA module2 capture Low
CCAP2L_Page           EQU      000h

CCAP3L                DATA     0EDH     //PCA module3 capture Low
CCAP3L_Page           EQU      000h

CCAP4L                DATA     0EEH     //PCA module4 capture Low
CCAP4L_Page           EQU      000h

CCAP5L                DATA     0EFH     //PCA module5 capture Low
CCAP5L_Page           EQU      000h

B                     DATA     0F0H     //B Register
B_Page                EQU      000h

PAOE                  DATA     0F1H     //PWM Additional Output Enable
PAOE_Page             EQU      000h
// (bits in PAOE)
P47OP4                EQU      080h
P41OP2                EQU      040h
P40OP2                EQU      020h
P24OP2                EQU      010h
P26OP4                EQU      008h
P21OP0                EQU      004h
P20OP0                EQU      002h
P22OP0                EQU      001h

PCAPWM0               DATA     0F2H     //PCA PWM0 Mode
PCAPWM0_Page          EQU      000h
// (bits in PCAPWM0)
P0RS1                 EQU      080h
P0RS0                 EQU      040h
P0PS2                 EQU      020h
P0PS1                 EQU      010h
P0PS0                 EQU      008h
P0INV                 EQU      004h
ECAP0H                EQU      002h
ECAP0L                EQU      001h

PCAPWM6               DATA     0F2H     //PCA PWM6 Mode
PCAPWM6_Page          EQU      001h
// (bits in PCAPWM6)
P6RS1                 EQU      080h
P6RS0                 EQU      040h
P6PS2                 EQU      020h
P6PS1                 EQU      010h
P6PS0                 EQU      008h
P6INV                 EQU      004h
ECAP6H                EQU      002h
ECAP6L                EQU      001h

PCAPWM1               DATA     0F3H     //PCA PWM1 Mode
PCAPWM1_Page          EQU      000h
// (bits in PCAPWM1)
P1RS1                 EQU      080h
P1RS0                 EQU      040h
P1PS2                 EQU      020h
P1PS1                 EQU      010h
P1PS0                 EQU      008h
P1INV                 EQU      004h
ECAP1H                EQU      002h
ECAP1L                EQU      001h

PCAPWM7               DATA     0F3H     //PCA PWM7 Mode
PCAPWM7_Page          EQU      001h
// (bits in PCAPWM7)
P7RS1                 EQU      080h
P7RS0                 EQU      040h
P7PS2                 EQU      020h
P7PS1                 EQU      010h
P7PS0                 EQU      008h
P7INV                 EQU      004h
ECAP7H                EQU      002h
ECAP7L                EQU      001h

PCAPWM2               DATA     0F4H     //PCA PWM2 Mode
PCAPWM2_Page          EQU      000h
// (bits in PCAPWM2)
P2RS1                 EQU      080h
P2RS0                 EQU      040h
P2PS2                 EQU      020h
P2PS1                 EQU      010h
P2PS0                 EQU      008h
P2INV                 EQU      004h
ECAP2H                EQU      002h
ECAP2L                EQU      001h

PCAPWM3               DATA     0F5H     //PCA PWM3 Mode
PCAPWM3_Page          EQU      000h
// (bits in PCAPWM3)
P3RS1                 EQU      080h
P3RS0                 EQU      040h
P3PS2                 EQU      020h
P3PS1                 EQU      010h
P3PS0                 EQU      008h
P3INV                 EQU      004h
ECAP3H                EQU      002h
ECAP3L                EQU      001h

PCAPWM4               DATA     0F6H     //PCA PWM4 Mode
PCAPWM4_Page          EQU      000h
// (bits in PCAPWM4)
P4RS1                 EQU      080h
P4RS0                 EQU      040h
P4PS2                 EQU      020h
P4PS1                 EQU      010h
P4PS0                 EQU      008h
P4INV                 EQU      004h
ECAP4H                EQU      002h
ECAP4L                EQU      001h

PCAPWM5               DATA     0F7H     //PCA PWM5 Mode
PCAPWM5_Page          EQU      000h
// (bits in PCAPWM5)
P5RS1                 EQU      080h
P5RS0                 EQU      040h
P5PS2                 EQU      020h
P5PS1                 EQU      010h
P5PS0                 EQU      008h
P5INV                 EQU      004h
ECAP5H                EQU      002h
ECAP5L                EQU      001h

P6                    DATA     0F8H     //Port 6
P6_Page               EQU      000h
// (bits in P6)
P61                   BIT      P6.1
P60                   BIT      P6.0

CH                    DATA     0F9H     //PCA base timer High
CH_Page               EQU      000h

CCAP0H                DATA     0FAH     //PCA Module0 capture High
CCAP0H_Page           EQU      000h

CCAP6H                DATA     0FAH     //PCA Module6 capture High
CCAP6H_Page           EQU      001h

CCAP1H                DATA     0FBH     //PCA Module1 capture High
CCAP1H_Page           EQU      000h

CCAP7H                DATA     0FBH     //PCA Module7 capture High
CCAP7H_Page           EQU      001h

CCAP2H                DATA     0FCH     //PCA Module2 capture High
CCAP2H_Page           EQU      000h

CCAP3H                DATA     0FDH     //PCA Module3 capture High
CCAP3H_Page           EQU      000h

CCAP4H                DATA     0FEH     //PCA Module4 capture High
CCAP4H_Page           EQU      000h

CCAP5H                DATA     0FFH     //PCA Module5 capture High
CCAP5H_Page           EQU      000h


//===== Page P =====//
IAPLB_P               EQU      003h     //IAP Low Boundary
// (bits in IAPLB)
IAPLB6_P              EQU      080h
IAPLB5_P              EQU      040h
IAPLB4_P              EQU      020h
IAPLB3_P              EQU      010h
IAPLB2_P              EQU      008h
IAPLB1_P              EQU      004h
IAPLB0_P              EQU      002h

CKCON2_P              EQU      040h     //Clock Control 2
// (bits in CKCON2)
XTGS1_P               EQU      080h
XTGS0_P               EQU      040h
XTALE_P               EQU      020h
IHRCOE_P              EQU      010h
MCKS1_P               EQU      008h
MCKS0_P               EQU      004h
OSCS1_P               EQU      002h
OSCS0_P               EQU      001h

CKCON3_P              EQU      041h     //Clock Control 3
// (bits in CKCON3)
LSCKS_P               EQU      080h
RTCCS2_P              EQU      040h
FWKP_P                EQU      020h
WDTFS_P               EQU      010h
MCKD1_P               EQU      008h
MCKD0_P               EQU      004h
MCDS1_P               EQU      002h
MCDS0_P               EQU      001h

PCON2_P               EQU      044h     //Power Control 2
// (bits in PCON2)
AWBOD1_P              EQU      080h
BO1S1_P               EQU      020h
BO1S0_P               EQU      010h
BO1RE_P               EQU      008h
EBOD1_P               EQU      004h
BO0RE_P               EQU      002h

PCON3_P               EQU      045h     //Power Control 3
// (bits in PCON3)
IVREN_P               EQU      080h

SPCON0_P              EQU      048h     //SFR Page Control 0
// (bits in SPCON0)
RTCCTL_P              EQU      080h
P6CTL_P               EQU      040h
P4CTL_P               EQU      020h
WRCTL_P               EQU      010h
CKCTL1_P              EQU      008h
CKCTL0_P              EQU      004h
PWCTL1_P              EQU      002h
PWCTL0_P              EQU      001h

DCON0_P               EQU      04Ch     //Device Control 0
// (bits in DCON0)
HSE_P                 EQU      080h
IAPO_P                EQU      040h
HSE1_P                EQU      020h
IORCTL_P              EQU      004h
RSTIO_P               EQU      002h
OCDE_P                EQU      001h

PCON0_P               EQU      087h     //Power Control 0
// (bits in PCON0)
SMOD1_P               EQU      080h
SMOD0_P               EQU      040h
POF0_P                EQU      010h
GF1_P                 EQU      008h
GF0_P                 EQU      004h
PD_P                  EQU      002h
IDL_P                 EQU      001h

PCON1_P               EQU      097h     //Power Control 1
// (bits in PCON1)
SWRF_P                EQU      080h
EXRF_P                EQU      040h
MCDF_P                EQU      020h
RTCF_P                EQU      010h
BOF1_P                EQU      004h
BOF0_P                EQU      002h
WDTF_P                EQU      001h

RTCCR_P               EQU      0BEh     //RTC Control Register
// (bits in RTCCR)
RTCE_P                EQU      080h
RTCO_P                EQU      040h
RTCRL5_P              EQU      020h
RTCRL4_P              EQU      010h
RTCRL3_P              EQU      008h
RTCRL2_P              EQU      004h
RTCRL1_P              EQU      002h
RTCRL0_P              EQU      001h

CKCON1_P              EQU      0BFh     //Clock Control 1
// (bits in CKCON1)
XTOR_P                EQU      080h
XCKS5_P               EQU      020h
XCKS4_P               EQU      010h
XCKS3_P               EQU      008h
XCKS2_P               EQU      004h
XCKS1_P               EQU      002h
XCKS0_P               EQU      001h

CKCON0_P              EQU      0C7h     //Clock Control 0
// (bits in CKCON0)
AFS_P                 EQU      080h
ENCKM_P               EQU      040h
CKMIS1_P              EQU      020h
CKMIS0_P              EQU      010h
CCKS_P                EQU      008h
SCKS2_P               EQU      004h
SCKS1_P               EQU      002h
SCKS0_P               EQU      001h

WDTCR_P               EQU      0E1h     //Watch-dog-timer Control register
// (bits in WDTCR)
WREN_P                EQU      080h
NSW_P                 EQU      040h
ENW_P                 EQU      020h
CLRW_P                EQU      010h
WIDL_P                EQU      008h
PS2_P                 EQU      004h
PS1_P                 EQU      002h
PS0_P                 EQU      001h

P4_P                  EQU      0E8h     //Port 4
// (bits in P4)
P47_P                 EQU      080h
P45_P                 EQU      020h
P44_P                 EQU      010h
P41_P                 EQU      002h
P40_P                 EQU      001h

P6_P                  EQU      0F8h     //Port 6
// (bits in P6)
P61_P                 EQU      002h
P60_P                 EQU      001h

#endif
